<?php

// This file is part of the Certificate module for Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * letter_embedded certificate type
 *
 * @package    mod_certificate
 * @copyright  Mark Nelson <markn@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$pdf = new PDF($certificate->orientation, 'pt', 'LETTER', true, 'UTF-8', false);

$pdf->SetTitle($certificate->name);
$pdf->SetProtection(array('modify'));
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);
$pdf->SetAutoPageBreak(false, 0);
$pdf->AddPage();

// Define variables
// Landscape
if ($certificate->orientation == 'L') {
    $x = 28;
    $y = 125;
    $sealx = 590;
    $sealy = 425;
    $sigx = 130;
    $sigy = 440;
    $custx = 133;
    $custy = 440;
    $wmarkx = 100;
    $wmarky = 90;
    $wmarkw = 600;
    $wmarkh = 420;
    $brdrx = 0;
    $brdry = 0;
    $brdrw = 792;
    $brdrh = 612;
    $codey = 505;
} else { // Portrait
    $x = 28;
    $y = 170;
    $sealx = 440;
    $sealy = 590;
    $sigx = 85;
    $sigy = 580;
    $custx = 88;
    $custy = 580;
    $wmarkx = 78;
    $wmarky = 130;
    $wmarkw = 450;
    $wmarkh = 480;
    $brdrx = 10;
    $brdry = 10;
    $brdrw = 594;
    $brdrh = 771;
    $codey = 660;
}

// Get font families.
$fontsans = get_config('certificate', 'fontsans');
$fontserif = get_config('certificate', 'fontserif');

// Add images and lines
certificate_print_image($pdf, $certificate, CERT_IMAGE_BORDER, $brdrx, $brdry, $brdrw, $brdrh);
certificate_draw_frame_letter($pdf, $certificate);
// Set alpha to semi-transparency
$pdf->SetAlpha(0.1);
certificate_print_image($pdf, $certificate, CERT_IMAGE_WATERMARK, $wmarkx, $wmarky, $wmarkw, $wmarkh);
$pdf->SetAlpha(1);
certificate_print_image($pdf, $certificate, CERT_IMAGE_SEAL, $sealx, $sealy, '', '');
certificate_print_image($pdf, $certificate, CERT_IMAGE_SIGNATURE, $sigx, $sigy, '', '');

// Add text
$pdf->SetTextColor(0, 0, 120);
certificate_print_text($pdf, $x, $y - 25, 'C', $fontsans, '', 40, get_string('title', 'certificate'));
certificate_print_text($pdf, $x, $y + 175, 'C', $fontserif, '', 35, format_string($course->fullname));
certificate_print_text($pdf, $x, $y + 65, 'C', $fontserif, '', 30, fullname($USER));
certificate_print_text($pdf, $x, $y + 375, 'C', 'freesans', '', 10, 'www.50DollarFloridaADI.com  -  CustomerCare@50DollarFloridaADI.com');
certificate_print_text($pdf, $x, $y + 387, 'C', 'freesans', '', 10, 'Online CE, LLC  - 3651 Lindell Road, Ste D - Las Vegas, NV, 89103');

$pdf->SetTextColor(128, 0, 0);
certificate_print_text($pdf, $x, $y + 245, 'C', 'freesans', '', 25,  'Certificate # 0000000'.$value);

$pdf->SetTextColor(0, 0, 0);
certificate_print_text($pdf, $x, $y + 25, 'C', $fontserif, 'i', 12, get_string('certify', 'certificate'));
certificate_print_text($pdf, $x, $y + 165, 'C', $fontserif, 'i', 12, get_string('statement', 'certificate'));
certificate_print_text($pdf, $x, $y + 115, 'C', 'freesans', '', 15, 'Citation # 000' . $USER->profile['CitationNumber']);
certificate_print_text($pdf, $x, $y + 330, 'C', $fontserif, '', 15, certificate_get_date($certificate, $certrecord, $course));
certificate_print_text($pdf, $x, $y + 100, 'C', 'freesans', '', 15, $USER->profile['stateofrecord']  . ' License #' . $USER->profile['DriversLicense']);
certificate_print_text($pdf, $x, $y + 275, 'C', 'freesans', '', 12, 'If there is not an 8-digit number here, then there was an error in your submission.');
certificate_print_text($pdf, $x, $y + 290, 'C', 'freesans', '', 12, 'Email us at Customer Care@50DollarFloridaADI.com and we will amend your error.');
certificate_print_text($pdf, $x, $y + 283, 'C', $fontserif, '', 10, certificate_get_grade($certificate, $course));
certificate_print_text($pdf, $x, $y + 311, 'C', $fontserif, '', 10, certificate_get_outcome($certificate, $course));
if ($certificate->printhours) {
    certificate_print_text($pdf, $x, $y + 345, 'C', $fontserif, '', 15, get_string('credithours', 'certificate') . ': ' . $certificate->printhours);
}
//certificate_print_text($pdf, $x, $codey + 10, 'C', $fontserif, '', 10, 'Serial #' . certificate_get_code($certificate, $certrecord));
$i = 0;
if ($certificate->printteacher) {
    $context = context_module::instance($cm->id);
    if ($teachers = get_users_by_capability($context, 'mod/certificate:printteacher', '', $sort = 'u.lastname ASC', '', '', '', '', false)) {
        foreach ($teachers as $teacher) {
            $i++;
            certificate_print_text($pdf, $sigx, $sigy + ($i * 12), 'L', $fontserif, '', 12, fullname($teacher));
        }
    }
}

certificate_print_text($pdf, $custx, $custy, 'L', null, null, null, $certificate->customtext);
